<?php

namespace Drupal\ai_seolink_advisor\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form for seo.
 */
class KeywordForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'keyword_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Enter Website URL'),
      '#required' => TRUE,
      '#default_value' => '',
    ];
    if (isset($_GET['url']) && !empty($_GET['url'])) {
      $form['url']['#default_value'] = $_GET['url'];
    }
    // Submit button.
    $form['actions']['#type'] = 'actions';
    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('SEO Analyze'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    // Get the values from the form.
    $url = $form_state->getValue('url');

    // Redirect or process based on selected AI service and URL.
    $form_state->setRedirect('ai_seolink_advisor.analyzer', ['url' => $url, 'ai_service' => $ai_service]);
  }

}
