<?php

namespace Drupal\ai_seolink_advisor\Metric\File;

use Drupal\ai_seolink_advisor\Metric\AbstractMetric;

class SitemapMetric extends AbstractMetric {

  /**
   * @inheritdoc
   */
  public function analyze(): string {
    $this->description = $this->t('Does the site use a site map file "sitemap.xml"?');
    if (empty($this->value)) {
      $this->impact = 1;
      return $this->t('The sitemap.xml file plays a crucial role in helping search engines discover and index the pages of a website efficiently.');
    }
    return $this->t('Yes');
  }
}
