<?php

namespace Drupal\ai_seolink_advisor\Metric\Page;

use Drupal\ai_seolink_advisor\Metric\AbstractMetric;

class RedirectMetric extends AbstractMetric {

  /**
   * @inheritdoc
   */
  public function analyze(): string {
    $this->description = $this->t('Does the page redirect to another url?');
    if ($this->value['redirect']) {
      $this->impact = 2;
      return $this->t('You should avoid redirects, as this could have impact on SEO');
    }
    return $this->t('No');
  }
}
