<?php

namespace Drupal\ai_seo_link_advisor\Service;

use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

class DynamicAiServiceLoader implements ContainerInjectionInterface {

  /**
   * The container interface.
   *
   * @var \Symfony\Component\DependencyInjection\ContainerInterface
   */
  protected $container;

  /**
   * Constructs a DynamicAiServiceLoader object.
   *
   * @param \Symfony\Component\DependencyInjection\ContainerInterface $container
   *   The container interface.
   */
  public function __construct(ContainerInterface $container) {
    $this->container = $container;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static($container);
  }

  /**
   * Gets the AI service based on configuration.
   *
   * @return mixed
   *   The AI service object.
   */
  public function getAiService() {
    $config = \Drupal::config('ai_seo_link_advisor.settings');
    $ai_service = $config->get('ai_service');

    if ($ai_service === 'openai') {
      return $this->container->get('ai_seo_link_advisor.openai_service');
    }
    elseif ($ai_service === 'gemini') {
      return $this->container->get('ai_seo_link_advisor.client');
    }

    return NULL;
  }
}
