<?php

namespace Drupal\seo_linkcheck_ai\Service;

use Drupal\key\KeyRepositoryInterface;
use Psr\Log\LoggerInterface;
use Nyholm\Psr7\Factory\Psr17Factory;
use Symfony\Component\HttpClient\Psr18Client;
use SoftCreatR\MistralAI\MistralAI;

class MistralAiService {
  protected $client;
  protected $logger;
  protected $keyRepository;

  public function __construct(LoggerInterface $logger, KeyRepositoryInterface $keyRepository) {
    $this->logger = $logger;
    $this->keyRepository = $keyRepository;

    // Fetch the API key from the Key module.
    $apiKey = $this->keyRepository->getKey('openai_api_key')->getKeyValue();

    $httpClient = new Psr18Client();
    $psr17Factory = new Psr17Factory();

    $this->client = new MistralAI($psr17Factory, $psr17Factory, $psr17Factory, $httpClient, $apiKey);
  }

  public function getRecommendations($message) {
    try {
      $response = $this->client->createChatCompletion([
        'model' => 'mistral-tiny',
        'messages' => [
          [
            'role' => 'user',
            'content' => $message,
          ],
        ],
      ]);

      if ($response->getStatusCode() === 200) {
        return json_decode($response->getBody()->getContents(), true);
      }
      else {
        $this->logger->error('Mistral AI API error: ' . $response->getStatusCode());
        return [];
      }
    }
    catch (\Exception $e) {
      $this->logger->error('Mistral AI API error: ' . $e->getMessage());
      return [];
    }
  }
}
