<?php

namespace Drupal\ai_seo_link_advisor\Analyzer\HttpClient;

use Drupal\ai_seo_link_advisor\Analyzer\HttpClient\Exception\HttpException;
use GuzzleHttp\Client as GuzzleClient;
use GuzzleHttp\Exception\GuzzleException;
use Psr\Http\Message\ResponseInterface;

/**
 * Provides an Client class for SEO analysis.
 */
class Client implements ClientInterface {

  /**
   * Configuration options for the HTTP client.
   *
   * @var array
   */
  protected $options = [
    'allow_redirects' => ['track_redirects' => TRUE],
    'headers' => [
      'User-Agent' => 'grgk-seo-analyzer/1.0',
    ],
  ];

  /**
   * Constructs a new get method.
   */
  public function get(string $url, array $options = []): ResponseInterface {
    if (empty($options)) {
      $options = $this->options;
    }
    try {
      return (new GuzzleClient(['verify' => FALSE]))->request('GET', $url, $options);
    }
    catch (GuzzleException $e) {
      throw new HttpException('Error getting url: ' . $e->getMessage(), $e->getCode(), $e);
    }
  }

}
