<?php

namespace Drupal\ai_seo_link_advisor\Analyzer\Metric\Page;

use Drupal\ai_seo_link_advisor\Analyzer\Metric\AbstractMetric;

/**
 * Provides a KeywordTitleMetric class for SEO analysis.
 */
class KeywordTitleMetric extends AbstractMetric {

  /**
   * Analyzes page.
   */
  public function analyze(): string {
    $this->description = $this->t('Does the meta title contain the keyword?');
    $this->name = 'Keyword' . $this->value['type'];

    // Check if there is a meta title.
    if (!isset($this->value['text']) || empty($this->value['text'])) {
      $this->impact = 10;
      return $this->t('You do not have a meta <title> tag. You should add this because it is really important for your SEO');
    }

    // Check if the title contains the keyword.
    if (stripos($this->value['text'], $this->value['keyword']) === FALSE) {
      $this->impact = $this->value['impact'];
      return $this->t('Can not find the keyword in the meta title tag. Adding it could improve SEO');
    }
    return $this->t('Good! Found the keyword in the meta title tag');
  }

}
