<?php

namespace Drupal\ai_seo_link_advisor\Service;

use Drupal\Core\Config\ConfigFactoryInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Service class for interacting with the DynamicAiServiceLoader.
 */
class DynamicAiServiceLoader {

  /**
   * The container interface.
   *
   * @var \Symfony\Component\DependencyInjection\ContainerInterface
   */
  protected $container;

  /**
   * The config factory interface.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * Constructs a DynamicAiServiceLoader object.
   *
   * @param \Symfony\Component\DependencyInjection\ContainerInterface $container
   *   The container interface.
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   *   The config factory interface.
   */
  public function __construct(ContainerInterface $container, ConfigFactoryInterface $configFactory) {
    $this->container = $container;
    $this->configFactory = $configFactory;
  }

  /**
   * Gets the AI service based on configuration.
   *
   * @return mixed
   *   The AI service object.
   */
  public function getAiService() {
    $config = $this->configFactory->get('ai_seo_link_advisor.settings');
    $ai_service = $config->get('ai_service');

    if ($ai_service === 'openai') {
      return $this->container->get('ai_seo_link_advisor.openai_service');
    }
    elseif ($ai_service === 'gemini') {
      return $this->container->get('ai_seo_link_advisor.client');
    }

    return NULL;
  }

}
