<?php

namespace Drupal\ai_seo_link_advisor\Analyzer\Metric\Page;

use Drupal\ai_seo_link_advisor\Analyzer\Metric\AbstractMetric;

/**
 * Provides a KeywordPathMetric class for SEO analysis.
 */
class KeywordPathMetric extends AbstractMetric {

  /**
   * Analyzes page.
   */
  public function analyze(): string {
    $this->description = $this->t('Does the page path contain the keyword?');
    $this->name = 'Keyword' . $this->value['type'];
    if (stripos($this->value['text'], $this->value['keyword']) === FALSE) {
      $this->impact = $this->value['impact'];
      return $this->t('Can not find the keyword in path. Adding it could improve SEO');
    }
    return $this->t('Good! Found the keyword in the path');
  }

}
