<?php

namespace Drupal\ai_seo_link_advisor\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form for seo analysis.
 */
class SeourlForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'seourl_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    // Define a text field for entering the website URL.
    $form['url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Enter Website URL'),
      '#required' => TRUE,
      '#default_value' => '',
    ];
    // If a URL is provided in the query string, set it as the default value.
    if (isset($_GET['url']) && !empty($_GET['url'])) {
      $form['url']['#default_value'] = $_GET['url'];
    }
    // Define the actions section with a submit button.
    $form['actions']['#type'] = 'actions';
    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('SEO Analyze'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    // Get the URL value from the form submission.
    $url = $form_state->getValue('url');

    // Redirect to the analyzer route with the URL parameter.
    $form_state->setRedirect('ai_seo_link_advisor.analyzer', ['url' => $url]);
  }

}
