<?php

namespace Drupal\ai_seo_link_advisor\Analyzer\Metric\Page;

/**
 * Provides a KeywordDensityMetric class for SEO analysis.
 */
class KeywordDensityMetric extends AbstractKeywordDensityMetric {

  /**
   * Analyzes page.
   */
  public function analyze(): string {
    $this->description = $this->t('Keyword density in page content');

    // Check if $this->value is an array and contains the necessary keys.
    if (!is_array($this->value) || !isset($this->value['text'], $this->value['stop_words'])) {
      return $this->t('Invalid input data for keyword density analysis.');
    }

    if (is_null($this->value['text'])) {
      return $this->t('Please enter a keyword first.');
    }

    $keywords = $this->analyseKeywords($this->value['text'], $this->value['stop_words']);
    $this->value['keywords'] = $keywords;
    $overusedWords = $this->getOverusedKeywords($keywords);

    if (!empty($this->keyword)) {
      return $this->analyzeWithKeyword($keywords, $overusedWords);
    }

    if (!empty($overusedWords)) {
      $this->value['overused'] = $overusedWords;
      $this->impact = 3;
      return $this->t('There are some overused keywords on the site. You should consider limiting the use of overused keywords.');
    }

    return $this->t('The keyword density on the site looks good.');
  }

  /**
   * Analyzes page.
   */
  protected function analyzeWithKeyword(array $keywords, array $overusedWords): string {
    $this->name = 'KeywordDensityKeyword';
    $this->value['keywords'] = $keywords;
    $this->value['keyword'] = $this->keyword;
    foreach ($keywords as $group) {
      foreach ($group as $phrase => $count) {
        if (stripos($phrase, $this->keyword) !== FALSE) {
          if (in_array($this->keyword, $overusedWords)) {
            $this->impact = 4;
            return $this->t('The keyword is overused on the site. Try to reduce its occurrence');
          }
          return $this->t('Good! The keyword is among the most popular keywords on the site');
        }
      }
    }
    $this->impact = 4;
    return $this->t('You should consider adding your keyword to the site content');
  }

}
