<?php

namespace Drupal\ai_seo_link_advisor\Analyzer\Metric\Page;

use Drupal\ai_seo_link_advisor\Analyzer\Metric\AbstractMetric;

/**
 * Provides a KeywordPathMetric class for SEO analysis.
 */
class KeywordPathMetric extends AbstractMetric {

  /**
   * Analyzes page.
   */
  public function analyze(): string {
    $this->description = $this->t('Does the page path contain the keyword?');
    $this->name = 'Keyword' . ($this->value['type'] ?? 'Unknown');

    // Ensure $this->value is array and 'text','keyword' exist and strings.
    if (is_array($this->value) && isset($this->value['text'], $this->value['keyword']) && is_string($this->value['text']) && is_string($this->value['keyword'])) {

      if (stripos($this->value['text'], $this->value['keyword']) === FALSE) {
        $this->impact = $this->value['impact'] ?? 'Unknown Impact';
        return $this->t('Cannot find the keyword in the path. Adding it could improve SEO');
      }
      return $this->t('Good! Found the keyword in the path');
    }

    // Handle $this->value is not valid array or expected keys not present.
    return $this->t('Invalid input data for keyword path analysis.');
  }

}
