<?php

namespace Drupal\ai_support_bot\Controller;

use Drupal\Core\Controller\ControllerBase;

/**
 * AI Support Bot clear class.
 *
 * @AIQAnswers
 * Defines AIQAnswers Controller class.
 */
class AIQAnswers extends ControllerBase {
  protected $connection;

  /**
   * Constructs a new HelloForm object.
   */
  public function __construct() {
    $this->connection = \Drupal::database();
  }

  /**
   * Get question.
   */
  public function getQuestionAnswer($question) {
    $q1 = strtolower($question);
    $qArr = explode(' ', $q1);
    $answers = '';
    $questions = '';
    $result = [];
    $answer = 'no-answer';
    $query = db_select('ai_support_bot', 'v');
    $query->fields('v');
    $results = $query->execute()->fetchAll();
    foreach ($results as $key => $value) {
      // Test if question contains the word.
      if (in_array(strtolower($value->words), $qArr)) {
        $answer = $value->answers;
        $this->storeNewQuestion($value->words, $value->qid, $value->answers);
        break;
      }
    }
    if ($answer == 'no-answer') {
      $this->storeNewQuestion($question, 0, $answer);
    }
    // If not found.
    return $answer;
  }

  /**
   * Store question.
   */
  private function storeNewQuestion($question = '', $qid = 0, $answer = '') {
    $user = \Drupal::currentUser();
    // Empty the table.
    $values = [];
    $query = db_select('ai_support_bot_new_questions', 'v');
    $query->condition('v.question', $question);
    $query->fields('v');
    $results = $query->execute()->fetchAll();
    if (!empty($results)) {
      foreach ($results as $key => $value) {
        // Test if question contains the word.
        if (strtolower($value->question) == $question) {
          $query = \Drupal::database()->update('ai_support_bot_new_questions');
          $query->fields([
            'times_repeated' => ($value->times_repeated + 1),
            'created' => \Drupal::time()->getRequestTime(),
          ]);
          $query->condition('qid', $qid);
          $query->execute();
          break;
        }
      }
    }
    else {
      $values[] = [
        'question' => $question,
        'answer' => $answer,
        'qid' => $qid,
        'times_repeated' => 1,
        'created' => \Drupal::time()->getRequestTime(),
        'status' => 1,
        'uid' => $user->uid,
      ];
      $query = $this->connection->insert('ai_support_bot_new_questions')->fields(['question', 'answer', 'qid', 'times_repeated', 'created', 'status']);
      foreach ($values as $record) {
        $query->values($record);
      }
    }
    $query->execute();
    return;
  }

}
