<?php

namespace Drupal\ai_support_bot\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\InvokeCommand;
use Drupal\Core\Ajax\AppendCommand;
use Drupal\ai_support_bot\Controller\AIQAnswers;

/**
 *
 */
class AIForm extends FormBase {

  /**
   * Constructs a new HelloForm object.
   */
  public function __construct() {
    $this->bot = '<b>Ryan </b>';
  }

  /**
   * Returns a unique string identifying the form.
   *
   * The returned ID should be a unique string that can be a valid PHP function
   * name, since it's used in hook implementation names such as
   * hook_form_FORM_ID_alter().
   *
   * @return string
   *   The unique string identifying the form.
   */
  public function getFormId() {
    return 'ai_support_bot_form';
  }

  /**
   * Form constructor.
   *
   * @param array $form
   *   An associative array containing the structure of the form.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current state of the form.
   *
   * @return array
   *   The form structure.
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['ai_support_bot']['search_div'] = [
      '#type' => 'fieldset',
      '#weight' => 0,
      '#attributes' => [
        'hidden' => FALSE,
        'style' => 'display:block;position:relative;',
        'class' => ['form-control'],
      ],
    ];
    $form['ai_support_bot']['search_div']['answer_div'] = [
      '#type' => 'container',
      '#weight' => 0,
      '#attributes' => [
        'hidden' => FALSE,
        'style' => 'display:inline-block;overflow: auto;overflow-y: scroll;position:relative;width:100%;max-height:200px;min-height:50px;margin: 0px;',
        'class' => ['search-valid-message-answers'],
      ],
    ];

    $form['ai_support_bot']['search_div']['you-send-message'] = [
      '#type' => 'textfield',
      '#required' => TRUE,
    // '#ajax' => [
    //   'callback' => [$this, 'validateSearchAjax'],
    //   'event' => 'change',
    //   'progress' => array(
    //     'type' => 'throbber',
    //     'message' => t('Verifying you-send-message'),
    //   ),
    // ],
      '#attributes' => [
        'hidden' => FALSE,
        'style' => 'margin: 0px;
        position: relative;
        padding: 0px;
        text-align: center;
        width: 100%;
        outline: none;
        height: 30px;
        border-radius: 5px;',
        'class' => ['form-control'],
      ],
    ];
    $form['ai_support_bot']['search_div']['actions'] = [
      '#type' => 'submit',
      '#value' => 'Send',
      '#ajax' => [
        'callback' => [$this, 'validateSearchAjax'],
        'fade' => TRUE,
        'event' => 'click',
        'progress' => [
          'type' => 'throbber',
          'message' => $this->bot . 'is writing',
        ],
      ],
      '#attributes' => [
        'class' => [''],
        'hidden' => TRUE,
        'style' => '
      position: relative;
      height: 30px;
      padding:0px;
      margin: 5px 0 10px 0;
      width: 100%;
      border-radius: 5px;
      border: none;
      cursor: pointer;
      color: black;
      background-color: gray;
      transform: translateX(2px); ',
      ],
    ];
    $form['#cache'] = ['max-age' => 0];
    $form['#actions']['#submit']['#ajax']['callback'] = [$this, 'validateSearchAjax'];
    return $form;
  }

  /**
   * Ajax callback to validate the Search field.
   */
  public function AISupportBotValidator($form, $form_state) {
    if ($form_state->hasValue('you-send-message')) {
      // Pass a key => value to other submit callbacks.
      $SearchCheck = $form_state->getValue('you-send-message');
      if (str_replace(' ', '', $SearchCheck) != '') {
        return TRUE;
      }
      else {
        return FALSE;
      }
    }
  }

  /**
   *
   */
  public function validateSearchAjax(array &$form, FormStateInterface $form_state) {
    $SearchCheck = $form_state->getValue('you-send-message');
    $YourQuestionSearchCheck = t('<br><b style="color:blue;">You</b> ' . $SearchCheck);
    $valid = $this->AISupportBotValidator($form, $form_state);
    // $css = ['border' => '1px solid green'];
    $message = t('<br>' . $this->bot . ' Sure I can help you. let me check...');
    $Selector = '#edit-answer-div';
    $response = new AjaxResponse();
    $aiQuestions = new AIQAnswers();
    $answer = $aiQuestions->getQuestionAnswer($SearchCheck);
    // Remove the question from the field.
    $selectorSendReset = '#edit-you-send-message';
    $response->addCommand(new InvokeCommand($selectorSendReset, 'val', ['']));
    if ($answer != 'no-answer') {
      // $Content = t('<br>' . $this->bot . ' ' . $answer);
      $Content = '<br>' . $this->bot . '</b> ' . $answer;
      $response->addCommand(new AppendCommand($Selector, $YourQuestionSearchCheck));
      $response->addCommand(new AppendCommand($Selector, $Content));
      return $response;
    }
    // $css = ['border' => '1px solid red'];
    $message = t('<br>' . $this->bot . ' I couldn\'t find any related answer to ' . $SearchCheck . ', please ask another question!');
    $response->addCommand(new AppendCommand($Selector, $YourQuestionSearchCheck));
    $response->addCommand(new AppendCommand($Selector, $message . ' ' . $answer));
    return $response;
  }

  /**
   *
   */
  public function validateSearchAjaxBasics($SearchCheck) {
    $standardQuestions = [
      "hi" => "Hello, My name is '. $this->bot . ' how can I help you today?",
      "bye" => "It was nice talking to you. Have a good one!",
      "no" => "Alright, I'm sorry, maybe you can ask me something else, or rephrase your question please",
    ];
    $Selector = '#search-valid-message';
    // $css = ['border' => '1px solid green'];
    foreach ($standardQuestions as $key => $value) {
      $Content = '<br>' . $this->bot . ' ' . $value;
    }
    return $Content;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    parent::validateForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    // Display result.
  }

}
