<?php

namespace Drupal\ai_support_bot\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Session\AccountInterface;
use Symfony\Component\HttpFoundation\Request;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
use Drupal\Core\StringTranslation\TranslationInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * AI Support Bot clear class.
 *
 * @AISupportBotSearchCheck
 * Defines AISupportBotSearchCheck Controller class.
 * Get a response code from any URL using Guzzle in Drupal 8!
 *
 * Usage:
 * In the head of your document:
 *
 * use Drupal\custom_guzzle_request\Http\CustomGuzzleHttp;
 *
 * In the area you want to return the result, using any URL for $url:
 *
 * $check = new CustomGuzzleHttp();
 * $response = $check->performRequest($url);
 *
 **/
class AISupportClientsCheck extends ControllerBase
{
    /**
     * To check if this variable exist in @getKeyword()
     *
     * @var SearchKey
     */
    protected $config;
    protected $url;
    /**
     * Constructs a new HelloForm object.
     */
    public function __construct()
    {
        $this->config = \Drupal::config('ai_support_bot.settings');
        $this->connection = \Drupal::database();
        $this->currentUser = \Drupal::currentUser();
        $this->url = 'http://dr8.site/api/v1/ai_support_bot/clients?_format=json';
    }
    public function ai_analytics_send_questions($question = '', $qid = 0, $answer = '', $hosts = '')
    {
        $client = new \GuzzleHttp\Client();
        $username = $this->config->get('share_analytic_ddkits_username');
        $pass = $this->config->get('share_analytic_ddkits_password');
        $auth = 'Basic '. base64_encode($username . ':' . $pass);
        try {
            $response = $client->post($endpoint, [
              'form_params' => [
                'question' => $question,
                'answer' => $answer,
                'qid' => $qid,
                'hosts' => $hosts,
              ],
              'headers' => [
                  'Authorization' => $auth,
                  'Content-Type' => 'application/json',
              ],
            ]);
            \Drupal::logger('ai_support_bot')->notice($response);
        } catch (RequestException $e) {
            // Logs an error
            \Drupal::logger('ai_support_bot')->error($e);
        }
    }
}
