<?php

namespace Drupal\ai_support_bot\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Session\AccountInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * AI Support Bot clients class.
 *
 * @AIClients
 * Defines AISupportBotSearchCheck Controller class.
 */
class AIClients extends ControllerBase {
  /**
   * To check if this variable exist in @getKeyword()
   *
   * @var SearchKey
   */
  protected $SearchKey;

  /**
   * Constructs a new HomeController object.
   */
  public function __construct() {
    $this->SearchKey = 'no';
  }

  /**
   *
   */
  public function getNewQuestions() {
    $query = db_select('ai_support_bot_new_questions', 'v');
    $query->fields('v');
    $results = $query->execute()->fetchAll();
    $final = json_decode(json_encode($results), TRUE);
    return $final;
  }

  /**
   *
   */
  public function content(AccountInterface $user, Request $request) {
    $questions = $this->getNewQuestions();
    return [
      '#type' => 'markup',
      '#markup' => 'New questions are' . print_r($questions, TRUE),
    ];
  }

}
