<?php

namespace Drupal\ai_support_bot\Controller;

use Drupal\Core\Controller\ControllerBase;

/**
 * AI Support Bot clear class.
 *
 * @AISupportBotSearchCheck
 * Defines AISupportBotSearchCheck Controller class.
 * Get a response code from any URL using Guzzle in Drupal 8!
 *
 * Usage:
 * In the head of your document:
 *
 * use Drupal\custom_guzzle_request\Http\CustomGuzzleHttp;
 *
 * In the area you want to return the result, using any URL for $url:
 *
 * $check = new CustomGuzzleHttp();
 * $response = $check->performRequest($url);
 **/
class AISupportClientsCheck extends ControllerBase {
  /**
   * To check if this variable exist in @getKeyword()
   *
   * @var SearchKey
   */
  protected $config;
  protected $baseUrl;
  protected $url;
  protected $loginUrl;
  protected $logOutUrl;
  protected $clientFactory;

  /**
   * Constructs a new HelloForm object.
   */
  public function __construct() {
    $this->baseUrl = 'http://dr8.site';
    $this->config = \Drupal::config('ai_support_bot.settings');
    $this->connection = \Drupal::database();
    $this->currentUser = \Drupal::currentUser();
    $this->url = $this->baseUrl . '/api/v1/ai_support_bot/clients?_format=json';
    $this->loginUrl = $this->baseUrl . '/user/login?_format=json';
    $this->logOutUrl = $this->baseUrl . '/user/logout?_format=json';
    $this->clientFactory = \Drupal::service('http_client_factory');
  }

  /**
   *
   */
  public function ai_analytics_send_questions($question = '', $qid = 0, $answer = '', $hosts = '') {
    $username = $this->config->get('share_analytic_ddkits_username');
    $pass = $this->config->get('share_analytic_ddkits_password');
    $auth = 'Basic ' . base64_encode($username . ':' . $pass);
    $token = '';
    // First get the CRF token to post.
    $tokenF = $this->curlGetToken(NULL, "POST");
    // $token = $tokenF['X-CSRF-Token'];
    \Drupal::logger('ai_support_bot')->notice($tokenF);
    // If token retrieved then continue.
  }

  /**
   *
   */
  public function curlGetToken($loginout = 'login', $method = NULL, $token = '') {
    $username = (string) $this->config->get('share_analytic_ddkits_username');
    $pass = (string) $this->config->get('share_analytic_ddkits_password');
    $auth = (string) 'Basic ' . base64_encode($username . ':' . $pass);
    $token = '';
    $methodIs = ($method) ?: "POST";
    $curl = curl_init();
    $url = '';
    $service_url = $this->baseUrl . '/user/login?_format=json';
    $post_data = [
      'username' => $username,
      'password' => $pass,
    ];
    // We format post data as application/x-www-form-urlencoded so make
    // sure that you tick it under the rest server parser options.
    $post_data = http_build_query($post_data, '', '&');

    // cURL.
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, $service_url);
    curl_setopt($curl, CURLOPT_HTTPHEADER, ['Accept: application/json', $this->get_csrf_header()]);
    // We want curl to return a string.
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
    // Choose method POST.
    curl_setopt($curl, CURLOPT_POST, TRUE);
    // Feed the data to POST to curl.
    curl_setopt($curl, CURLOPT_POSTFIELDS, $post_data);
    // Make it verbose for debugging.
    curl_setopt($curl, CURLOPT_VERBOSE, TRUE);
    // Go!
    $response = curl_exec($curl);
    $logged_user = json_decode($response);
    $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    if ($http_code == 200) {
      $logged_user = json_decode($response);
      \Drupal::logger('ai_support_bot')->notice($http_code . ' Curl got results ' . $url . ' > ' . $response . '</pre>');
      return $logged_user;
    }
    else {
      $http_message = curl_error($curl);
      // Logs an error.
      \Drupal::logger('ai_support_bot')->error($http_code . ' Unable to connect to Basic CMS Engine!
            Username or password incorrect!
            Please enter valid username and password! <pre>' . print_r($http_message, TRUE) . '</pre>');
      return $http_message;
    }
    setcookie($logged_user->session_name, $logged_user->sessid, time() + 10000, '/');
  }

  /**
   *
   */
  public function get_csrf_header() {
    $curl_get = curl_init();
    curl_setopt_array($curl_get, [
      CURLOPT_RETURNTRANSFER => 1,
      CURLOPT_URL => $this->baseUrl . '/rest/session/token',
    ]);
    $csrf_token = curl_exec($curl_get);
    curl_close($curl_get);
    \Drupal::logger('ai_support_bot')->notice(' CSRF => ' . $csrf_token . '');

    return 'X-CSRF-Token: ' . $csrf_token;
  }

}
