# CLAUDE.md

This file provides guidance to Claude Code (claude.ai/code) when working with code in this repository.

## Build/Lint/Test Commands
- This is a Drupal module - no specific build commands required
- Drupal coding standards validation: `phpcs --standard=Drupal --extensions=php,module,inc,install,test,profile,theme,css,info,txt,md,yml ./`
- PHPStan: `phpstan analyse -c phpstan.neon ./`
- Test: `phpunit ./tests/src/`

## Coding Standards
- Follow Drupal coding standards (PSR-4, PSR-12)
- Use appropriate namespaces: `Drupal\ai_talk_with_node\...`
- Dependency injection for all services
- DocBlock all methods and classes with appropriate tags
- Class names: PascalCase
- Method/variable names: camelCase
- Use strict type checking where possible
- Indentation: 2 spaces, no tabs
- Use Drupal's dependency injection patterns
- Use Drupal's translation system for user-facing strings (t(), @t)
- Properly handle Drupal entity systems (node, file, etc.)