<?php

namespace Drupal\ai_translate_lb_asymmetric\Plugin\FieldTextExtractor;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldConfigInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\ai_translate\Attribute\FieldTextExtractor;
use Drupal\ai_translate\Plugin\FieldTextExtractor\TextFieldExtractor;
use Drupal\block_content\Entity\BlockContent;

/**
 * A field text extractor plugin for text fields in Asymmetric paragraph config.
 */
#[FieldTextExtractor(
  id: "text_lb_asymmetric",
  label: new TranslatableMarkup('Text'),
  field_types: [
    'title',
    'text',
    'text_with_summary',
    'text_long',
    'string',
    'string_long',
  ]
)]
class TextFieldLbAsymmetricExtractor extends TextFieldExtractor {

  /**
   * {@inheritDoc}
   */
  public function shouldExtract(ContentEntityInterface $entity, FieldConfigInterface $fieldDefinition): bool {
    // Always extracts text fields in Asymmetric Layout builder config.
    if ($entity instanceof BlockContent || $fieldDefinition->isTranslatable()) {
      return TRUE;
    }
    return FALSE;
  }

}
