<?php

namespace Drupal\ai_translate_paragraph_asymetric\Plugin\FieldTextExtractor;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldConfigInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\ai_translate\Attribute\FieldTextExtractor;
use Drupal\ai_translate\FieldTextExtractorInterface;
use Drupal\ai_translate\Plugin\FieldTextExtractor\TextFieldExtractor;
use Drupal\paragraphs\ParagraphInterface;

/**
 * A field text extractor plugin for text fields in Asymmetric paragraph config.
 */
#[FieldTextExtractor(
  id: "text_paragraph_asymmetric",
  label: new TranslatableMarkup('Text'),
  field_types: [
    'title',
    'text',
    'text_with_summary',
    'text_long',
    'string',
    'string_long',
  ]
)]
class TextFieldParagraphAsymetricExtractor extends TextFieldExtractor implements FieldTextExtractorInterface {

  /**
   * {@inheritDoc}
   */
  public function shouldExtract(ContentEntityInterface $entity, FieldConfigInterface $fieldDefinition): bool {
    // Always extracts text fields in Asymmetric paragraph config.
    if ($entity instanceof ParagraphInterface) {
      return TRUE;
    }
    return FALSE;
  }

}
