<?php

namespace Drupal\ai_translate_textfield;

/**
 * An interface defining the API for an AI translation service implementation.
 */
interface AiTranslatorInterface {

  const SUPPORTED_FIELD_WIDGETS = ['string_textarea', 'text_textarea', 'string_textfield', 'text_textfield', 'text_textarea_with_summary'];

  /**
   * Fetch translation from the AI service.
   *
   * @param string $text
   *   The text to be translated.
   * @param string $targetLang
   *   The target language.
   * @param bool $isHtml
   *   If the text should be treated as HTML.
   *
   * @return string
   *   The translated text.
   */
  public function translateText(string $text, string $targetLang, bool $isHtml = FALSE);

}
