<?php

namespace Drupal\ai_translate_textfield;

use DeepL\TranslateTextOptions;
use DeepL\Translator;
use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Symfony\Component\Config\Definition\Exception\InvalidConfigurationException;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * The DeepL translator implementation.
 */
class DeepLTranslator implements AiTranslatorInterface, ContainerInjectionInterface {

  /**
   * The configuration of this module.
   *
   * @var array
   */
  protected array $config = [];

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    $instance = new static();
    $config = $container->get('config.factory')->get('ai_translate_textfield.settings')->get('translator_config');
    if (!isset($config['deepl'])) {
      throw new InvalidConfigurationException('The DeepL translator is not configured.');
    }
    $instance->config = $config['deepl'];
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function translateText(string $text, string $targetLang, bool $isHtml = FALSE) {

    if (isset($this->config['language_fallbacks'][$targetLang])) {
      $targetLang = $this->config['language_fallbacks'][$targetLang];
    }

    $options = [];

    if ($isHtml) {
      $options[TranslateTextOptions::TAG_HANDLING] = 'html';
    }

    try {
      $translator = new Translator($this->config['api_key'], $options);
      $translated = $translator->translateText($text, NULL, $targetLang, $options);
    }
    catch (\Exception $e) {
      return $text;
    }

    return $translated;
  }

}
