(function ($, Drupal) {
  'use strict';

  Drupal.behaviors.aiUpgradeStatus = {
    attach: function (context, settings) {
      // Auto-refresh the page every 30 seconds if there are modules in progress
      if ($('.status-in_progress', context).length > 0) {
        setTimeout(function() {
          window.location.reload();
        }, 30000);
      }

      // Update timestamps to relative time
      $('.timestamp', context).once('timestamp').each(function() {
        var timestamp = $(this).text();
        setInterval(function() {
          var time = new Date(timestamp);
          var now = new Date();
          var diff = Math.floor((now - time) / 1000);
          
          var timeAgo;
          if (diff < 60) {
            timeAgo = 'just now';
          } else if (diff < 3600) {
            timeAgo = Math.floor(diff / 60) + ' minutes ago';
          } else if (diff < 86400) {
            timeAgo = Math.floor(diff / 3600) + ' hours ago';
          } else {
            timeAgo = Math.floor(diff / 86400) + ' days ago';
          }
          
          $(this).text('Last updated: ' + timeAgo);
        }, 60000);
      });
    }
  };

})(jQuery, Drupal);
