<?php

namespace Drupal\ai_upgrade_assistant\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\State\StateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Controller for terminal output operations.
 */
class TerminalController extends ControllerBase {

  /**
   * The state service.
   *
   * @var \Drupal\Core\State\StateInterface
   */
  protected $state;

  /**
   * Constructs a new TerminalController object.
   *
   * @param \Drupal\Core\State\StateInterface $state
   *   The state service.
   */
  public function __construct(StateInterface $state) {
    $this->state = $state;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('state')
    );
  }

  /**
   * Gets the latest terminal output.
   *
   * @return \Symfony\Component\HttpFoundation\JsonResponse
   *   JSON response containing the terminal output.
   */
  public function getOutput() {
    $output = $this->state->get('ai_upgrade_assistant.terminal_output', []);
    
    return new JsonResponse([
      'output' => $output,
    ]);
  }

}
