<?php

namespace Drupal\ai_upgrade_assistant\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form controller for the upgrade analysis entity edit forms.
 */
class UpgradeAnalysisForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildForm($form, $form_state);

    /** @var \Drupal\ai_upgrade_assistant\Entity\UpgradeAnalysis $entity */
    $entity = $this->entity;

    // Add a css class for custom styling
    $form['#attributes']['class'][] = 'upgrade-analysis-form';

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $result = parent::save($form, $form_state);

    /** @var \Drupal\ai_upgrade_assistant\Entity\UpgradeAnalysis $entity */
    $entity = $this->entity;

    $message_arguments = ['%label' => $entity->label()];
    $logger_arguments = [
      '%label' => $entity->label(),
      'link' => $entity->toLink($this->t('View'))->toString(),
    ];

    switch ($result) {
      case SAVED_NEW:
        $this->messenger()->addStatus($this->t('New upgrade analysis %label has been created.', $message_arguments));
        $this->logger('ai_upgrade_assistant')->notice('Created new upgrade analysis %label', $logger_arguments);
        break;

      case SAVED_UPDATED:
        $this->messenger()->addStatus($this->t('The upgrade analysis %label has been updated.', $message_arguments));
        $this->logger('ai_upgrade_assistant')->notice('Updated upgrade analysis %label.', $logger_arguments);
        break;
    }

    $form_state->setRedirect('entity.upgrade_analysis.canonical', ['upgrade_analysis' => $entity->id()]);

    return $result;
  }

}
