<?php

namespace Drupal\ai_upgrade_assistant\Service;

/**
 * Interface for the AI Upgrade Assistant cache warmer service.
 */
interface CacheWarmerInterface {

  /**
   * Warms the cache with upgrade patterns for specified modules.
   *
   * @param array $moduleNames
   *   Array of module names to warm cache for. If empty, warms for all modules.
   */
  public function warmCache(array $moduleNames = []);

  /**
   * Collects and analyzes patterns from specified modules.
   *
   * @param array $moduleNames
   *   Array of module names to collect patterns from. If empty, collects from all.
   */
  public function collectPatterns(array $moduleNames = []);

  /**
   * Invalidates cache for a specific module.
   *
   * @param string $moduleName
   *   The name of the module to invalidate cache for.
   */
  public function invalidateModuleCache($moduleName);

}
