<?php

namespace Drupal\Tests\ai_upgrade_assistant\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests the AI Upgrade Assistant functionality.
 *
 * @group ai_upgrade_assistant
 */
class AIUpgradeAssistantBrowserTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'ai_upgrade_assistant',
    'upgrade_status',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * A user with permission to use the AI Upgrade Assistant.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $adminUser;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    // Create and log in our privileged user.
    $this->adminUser = $this->drupalCreateUser([
      'access upgrade status',
      'administer site configuration',
    ]);
    $this->drupalLogin($this->adminUser);
  }

  /**
   * Tests the upgrade assistant overview page.
   */
  public function testOverviewPage() {
    $this->drupalGet('admin/reports/upgrade-assistant');
    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->pageTextContains('AI Upgrade Assistant');
  }

  /**
   * Tests the module analysis functionality.
   */
  public function testModuleAnalysis() {
    // Create a test module for analysis.
    $module_path = $this->createTestModule();

    // Start analysis.
    $this->drupalGet('admin/reports/upgrade-assistant/analyze/test_module');
    $this->assertSession()->statusCodeEquals(200);
    
    // Check that analysis results are displayed.
    $this->assertSession()->pageTextContains('Analysis Results');
    $this->assertSession()->pageTextContains('test_module');
  }

  /**
   * Creates a test module for analysis.
   *
   * @return string
   *   The path to the created test module.
   */
  protected function createTestModule() {
    $module_path = $this->publicFilesDirectory . '/test_module';
    mkdir($module_path, 0777, TRUE);
    
    // Create test module files.
    file_put_contents($module_path . '/test_module.info.yml', "
name: Test Module
type: module
description: 'Test module for AI Upgrade Assistant.'
core_version_requirement: ^9 || ^10
");

    file_put_contents($module_path . '/test_module.module', "<?php

/**
 * @file
 * Contains test_module.module.
 */

use Drupal\Core\Routing\RouteMatchInterface;

/**
 * Implements hook_help().
 */
function test_module_help(\$route_name, RouteMatchInterface \$route_match) {
  switch (\$route_name) {
    case 'help.page.test_module':
      return t('This is a test module.');
  }
}
");

    return $module_path;
  }

}
