(function ($, Drupal) {
  'use strict';

  Drupal.behaviors.updateHistory = {
    attach: function (context, settings) {
      // Filter functionality
      const $moduleFilter = $('.update-history-filter-module', context);
      const $statusFilter = $('.update-history-filter-status', context);
      const $table = $('.update-history-table', context);

      function filterTable() {
        const moduleFilter = $moduleFilter.val().toLowerCase();
        const statusFilter = $statusFilter.val();

        $table.find('tbody tr').each(function () {
          const $row = $(this);
          const module = $row.find('td:first').text().toLowerCase();
          const status = $row.find('.status-message').attr('data-status');

          const moduleMatch = !moduleFilter || module.includes(moduleFilter);
          const statusMatch = !statusFilter || status === statusFilter;

          $row.toggle(moduleMatch && statusMatch);
        });
      }

      $moduleFilter.on('input', filterTable);
      $statusFilter.on('change', filterTable);

      // Initialize status message styling
      $('.status-message', context).each(function () {
        const $status = $(this);
        const status = $status.text().toLowerCase();
        $status.attr('data-status', status);
        $status.addClass(`status-message--${status}`);
      });

      // Initialize code highlighting for patches
      if (typeof hljs !== 'undefined') {
        $('pre code.language-diff', context).each(function(i, block) {
          hljs.highlightBlock(block);
        });
      }
    }
  };

})(jQuery, Drupal);
