(function ($, Drupal, drupalSettings) {
  'use strict';

  Drupal.behaviors.aiUpgradeAssistantConfig = {
    attach: function (context, settings) {
      // Initialize form validation
      $(context).find('.ai-config-page form').once('configFormValidation').each(function () {
        const $form = $(this);
        
        // Add custom validation classes
        $form.find('input[required], select[required], textarea[required]').each(function () {
          const $field = $(this);
          const $label = $form.find('label[for="' + $field.attr('id') + '"]');
          $label.addClass('required');
        });

        // Show/hide password fields
        $form.find('input[type="password"]').each(function () {
          const $input = $(this);
          const $wrapper = $input.parent();
          
          // Add toggle button
          const $toggle = $('<button type="button" class="ai-password-toggle">' +
            '<span class="material-icons">visibility_off</span>' +
            '</button>');
          
          $wrapper.css('position', 'relative');
          $wrapper.append($toggle);
          
          $toggle.on('click', function (e) {
            e.preventDefault();
            const isVisible = $input.attr('type') === 'text';
            $input.attr('type', isVisible ? 'password' : 'text');
            $toggle.find('.material-icons').text(isVisible ? 'visibility_off' : 'visibility');
          });
        });

        // Add loading state during AJAX calls
        $form.find('[data-drupal-selector*="edit-submit"]').on('click', function () {
          const $button = $(this);
          const $card = $button.closest('.ai-card');
          
          if ($card.length) {
            $card.find('.ai-card__content').addClass('is-loading');
          }
        });
      });

      // Initialize tooltips for help icons
      $(context).find('.ai-card__content .description').once('helpTooltip').each(function () {
        const $description = $(this);
        const $wrapper = $description.parent();
        
        // Add help icon
        const $helpIcon = $('<span class="material-icons ai-help-icon">help_outline</span>');
        $wrapper.find('label').append($helpIcon);
        
        // Create tooltip
        const $tooltip = $('<div class="ai-tooltip">' + $description.text() + '</div>');
        $helpIcon.append($tooltip);
        
        // Show/hide tooltip
        $helpIcon.hover(
          function () {
            $tooltip.fadeIn(200);
          },
          function () {
            $tooltip.fadeOut(200);
          }
        );
      });

      // Add CSS for new elements
      const style = document.createElement('style');
      style.textContent = `
        .ai-password-toggle {
          position: absolute;
          right: 1rem;
          top: 50%;
          transform: translateY(-50%);
          background: none;
          border: none;
          padding: 0;
          cursor: pointer;
          color: var(--ai-gray-500);
        }
        
        .ai-help-icon {
          margin-left: 0.5rem;
          font-size: 1rem;
          color: var(--ai-gray-500);
          cursor: help;
          vertical-align: middle;
        }
        
        label.required::after {
          content: "*";
          color: var(--ai-error);
          margin-left: 0.25rem;
        }
      `;
      document.head.appendChild(style);
    }
  };
})(jQuery, Drupal, drupalSettings);
