(function ($, Drupal, drupalSettings) {
  'use strict';

  Drupal.behaviors.aiUpgradeAssistantStatus = {
    attach: function (context, settings) {
      // Initialize progress ring animation
      const progressRing = context.querySelector('.ai-progress-ring__circle-progress');
      if (progressRing) {
        const progress = parseFloat(context.querySelector('.ai-progress-ring__percentage').textContent);
        const circumference = 2 * Math.PI * 54; // r=54 from the SVG
        const offset = circumference - (progress / 100) * circumference;
        progressRing.style.strokeDasharray = `${circumference} ${circumference}`;
        progressRing.style.strokeDashoffset = offset;
      }

      // Add hover effects for module items
      $(context).find('.ai-module-item').once('moduleItemHover').each(function () {
        const $item = $(this);
        const $actions = $item.find('.ai-module-item__actions');
        
        // Show actions on hover for desktop
        if (window.innerWidth > 768) {
          $actions.hide();
          $item.hover(
            function () {
              $actions.slideDown(200);
            },
            function () {
              $actions.slideUp(200);
            }
          );
        }
      });

      // Add tooltips for action buttons
      $(context).find('.ai-button[title]').once('buttonTooltip').each(function () {
        const $button = $(this);
        const title = $button.attr('title');
        
        // Create tooltip element
        const $tooltip = $('<div class="ai-tooltip">' + title + '</div>');
        $button.append($tooltip);
        
        // Show/hide tooltip on hover
        $button.hover(
          function () {
            $tooltip.fadeIn(200);
          },
          function () {
            $tooltip.fadeOut(200);
          }
        );
      });

      // Add staggered animation for module items
      $(context).find('.ai-module-item').once('moduleItemAnimation').each(function (index) {
        const $item = $(this);
        $item.css({
          'animation-delay': (index * 0.1) + 's'
        });
      });

      // Refresh status automatically
      $(context).find('.ai-upgrade-status').once('autoRefresh').each(function () {
        const refreshInterval = 60000; // 1 minute
        setInterval(function () {
          const refreshButton = context.querySelector('a[href*="ai_upgrade_assistant.upgrade"]');
          if (refreshButton) {
            refreshButton.click();
          }
        }, refreshInterval);
      });

      // Add CSS styles for tooltips
      const style = document.createElement('style');
      style.textContent = `
        .ai-tooltip {
          position: absolute;
          bottom: 100%;
          left: 50%;
          transform: translateX(-50%);
          padding: 0.5rem;
          background: var(--ai-gray-800);
          color: white;
          font-size: 0.75rem;
          border-radius: 0.25rem;
          white-space: nowrap;
          pointer-events: none;
          opacity: 0;
          transition: opacity 0.2s ease;
          z-index: 10;
        }
        
        .ai-tooltip::after {
          content: '';
          position: absolute;
          top: 100%;
          left: 50%;
          transform: translateX(-50%);
          border-width: 4px;
          border-style: solid;
          border-color: var(--ai-gray-800) transparent transparent transparent;
        }
      `;
      document.head.appendChild(style);
    }
  };
})(jQuery, Drupal, drupalSettings);
