(function ($, Drupal, drupalSettings) {
  'use strict';

  Drupal.behaviors.aiUpgradeAssistant = {
    attach: function (context, settings) {
      // Initialize start analysis button
      $('.start-analysis', context).once('upgrade-assistant').on('click', function(e) {
        e.preventDefault();
        Drupal.behaviors.aiUpgradeAssistant.startAnalysis();
      });

      // Initialize terminal output
      const terminal = $('#terminal-output', context);
      if (terminal.length) {
        this.initializeTerminal(terminal);
      }

      // Initialize action buttons
      $('.recommendation-actions .button', context).once('upgrade-assistant').each(function () {
        $(this).on('click', function (e) {
          if ($(this).data('action')) {
            e.preventDefault();
            Drupal.behaviors.aiUpgradeAssistant.handleAction($(this));
          }
        });
      });
    },

    startAnalysis: function() {
      const url = Drupal.url('admin/reports/upgrade-assistant/start');
      
      $.ajax({
        url: url,
        method: 'POST',
        success: function(response) {
          if (response.status === 'started') {
            $('.analysis-progress').show();
            Drupal.behaviors.aiUpgradeAssistant.pollProgress(response.batch_token);
          }
        },
        error: function(xhr, status, error) {
          console.error('Error starting analysis:', error);
          alert(Drupal.t('Error starting analysis. Please try again.'));
        }
      });
    },

    pollProgress: function(batchToken) {
      const progressUrl = Drupal.url('admin/reports/upgrade-assistant/check-status');
      
      const checkProgress = function() {
        $.ajax({
          url: progressUrl,
          method: 'GET',
          data: { token: batchToken },
          success: function(response) {
            $('.progress-bar').css('width', (response.current / response.total * 100) + '%');
            $('.progress-message').text(response.message);
            
            if (response.status === 'in_progress') {
              setTimeout(checkProgress, 1000);
            } else if (response.status === 'complete') {
              window.location.reload();
            }
          },
          error: function(xhr, status, error) {
            console.error('Error checking progress:', error);
          }
        });
      };

      checkProgress();
    },

    initializeTerminal: function (terminal) {
      // Add auto-scroll functionality
      terminal.scrollTop(terminal[0].scrollHeight);
    },

    appendToTerminal: function (terminal, message) {
      const line = $('<div class="terminal-line"></div>').text(message);
      terminal.append(line);
      terminal.scrollTop(terminal[0].scrollHeight);
    },

    handleAction: function (button) {
      const action = button.data('action');
      const url = Drupal.url('admin/reports/upgrade-assistant/action/' + action);
      
      $.ajax({
        url: url,
        method: 'POST',
        success: function (response) {
          if (response.redirect) {
            window.location = response.redirect;
          } else if (response.message) {
            alert(response.message);
          }
        },
        error: function (xhr, status, error) {
          console.error('Error:', error);
          alert(Drupal.t('An error occurred. Please try again.'));
        }
      });
    }
  };

})(jQuery, Drupal, drupalSettings);
