<?php

namespace Drupal\Tests\ai_upgrade_assistant;

use Drupal\Tests\BrowserTestBase;

/**
 * Provides a base class for AI Upgrade Assistant tests.
 */
abstract class TestBase extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'ai_upgrade_assistant',
    'upgrade_status',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * A test user with administrative privileges.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $adminUser;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    // Create and log in our admin user.
    $this->adminUser = $this->drupalCreateUser([
      'administer site configuration',
      'administer modules',
      'access administration pages',
      'access site reports',
    ]);
    $this->drupalLogin($this->adminUser);

    // Set up any necessary configuration.
    $this->config('ai_upgrade_assistant.settings')
      ->set('openai_api_key', 'test_key')
      ->save();
  }

  /**
   * Creates a mock project for testing.
   *
   * @param string $name
   *   The name of the test project.
   *
   * @return string
   *   The path to the test project.
   */
  protected function createMockProject($name) {
    $project_path = $this->publicFilesDirectory . '/test_projects/' . $name;
    mkdir($project_path, 0777, TRUE);
    return $project_path;
  }

  /**
   * Creates a mock patch file for testing.
   *
   * @param string $content
   *   The content of the patch.
   *
   * @return string
   *   The path to the test patch file.
   */
  protected function createMockPatch($content) {
    $patch_dir = $this->publicFilesDirectory . '/test_patches';
    mkdir($patch_dir, 0777, TRUE);
    $patch_file = $patch_dir . '/test.patch';
    file_put_contents($patch_file, $content);
    return $patch_file;
  }

  /**
   * Asserts that a service exists and is an instance of the expected class.
   *
   * @param string $service_id
   *   The service ID to check.
   * @param string $expected_class
   *   The expected class of the service.
   */
  protected function assertServiceExists($service_id, $expected_class) {
    $service = \Drupal::service($service_id);
    $this->assertInstanceOf(
      $expected_class,
      $service,
      sprintf('Service %s exists and is an instance of %s', $service_id, $expected_class)
    );
  }
}
