(function ($, Drupal, drupalSettings) {
  'use strict';

  Drupal.behaviors.aiAnalysisReport = {
    attach: function (context, settings) {
      // Tab Navigation
      $('.ai-tabs__item', context).once('aiTabInit').each(function () {
        $(this).on('click', function (e) {
          e.preventDefault();
          $('.ai-tabs__item').removeClass('ai-tabs__item--active');
          $(this).addClass('ai-tabs__item--active');
          
          const targetId = $(this).attr('href').substring(1);
          $('section').hide();
          $('#' + targetId).fadeIn();
        });
      });

      // Card Animations
      $('.ai-card', context).once('aiCardInit').each(function () {
        const observer = new IntersectionObserver(entries => {
          entries.forEach(entry => {
            if (entry.isIntersecting) {
              $(entry.target).addClass('ai-card--visible');
            }
          });
        });
        
        observer.observe(this);
      });

      // Advanced Options Toggle
      $('.ai-advanced-options__header', context).once('aiAdvancedInit').each(function () {
        $(this).on('click', function () {
          $(this).next('.ai-advanced-options__content').slideToggle();
          $(this).toggleClass('is-expanded');
        });
      });

      // Progress Bar Animations
      $('.ai-progress__bar', context).once('aiProgressInit').each(function () {
        const width = $(this).css('width');
        $(this).css('width', '0').animate({
          width: width
        }, 1000);
      });

      // Status Label Animations
      $('.ai-status-label--success, .ai-status-label--error', context).once('aiStatusInit').each(function () {
        $(this).addClass('ai-status-label--animated');
      });

      // Message Hover Effects
      $('.ai-message', context).once('aiMessageInit').each(function () {
        $(this).hover(
          function() { $(this).addClass('ai-message--hover'); },
          function() { $(this).removeClass('ai-message--hover'); }
        );
      });
    }
  };
})(jQuery, Drupal, drupalSettings);
