<?php

/**
 * @file
 * A script to set the HuggingFace API key directly in Drupal's state system.
 */

use Drupal\Core\DrupalKernel;
use Symfony\Component\HttpFoundation\Request;

// Bootstrap Drupal
$autoloader = require_once 'autoload.php';
$kernel = new DrupalKernel('prod', $autoloader);
$request = Request::createFromGlobals();
$kernel->boot();
$kernel->preHandle($request);
$container = $kernel->getContainer();

// Get state service
$state = $container->get('state');

// Get the API key from command line argument
if (empty($argv[1])) {
  echo "Please provide the HuggingFace API key as a command line argument.\n";
  echo "Usage: php set_api_key.php <api_key>\n";
  exit(1);
}

$api_key = $argv[1];

// Set the API key
$state->set('ai_upgrade_assistant.huggingface_api_key', $api_key);

// Verify the key was set
$saved_key = $state->get('ai_upgrade_assistant.huggingface_api_key');
if ($saved_key === $api_key) {
  echo "API key successfully saved.\n";
} else {
  echo "Failed to save API key.\n";
}
