<?php

namespace Drupal\ai_upgrade_assistant;

use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Access controller for the Upgrade Analysis entity.
 */
class UpgradeAnalysisAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    switch ($operation) {
      case 'view':
        return AccessResult::allowedIfHasPermission($account, 'view upgrade analysis');

      case 'update':
        return AccessResult::allowedIfHasPermission($account, 'edit upgrade analysis');

      case 'delete':
        return AccessResult::allowedIfHasPermission($account, 'delete upgrade analysis');
    }

    return AccessResult::neutral();
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermission($account, 'create upgrade analysis');
  }

}
