## INTRODUCTION

The MySQL VDB Provider is an experimental database module that works 
together with the AI module, to allow you to do vector searches 
in AI Search using just your existing MySQL database instead 
of specialised vector database.

It uses the mysql-vector class:
https://github.com/allanpichardo/mysql-vector
which does the actual vector search cosine similarity. However, to 
improve performance it does the search in two steps:

1. First it uses quantization and filters using the Hamming Distance
to retrieve vectors that are "close" (fast).
2. Second it ranks the remaining results by cosine similarity (slow)

## REQUIREMENTS

This module requires the Search API (search_api) and AI (ai) module.

## INSTALLATION

Install as you would normally install a contributed Drupal module.
See: https://www.drupal.org/node/895232 for further information.

## CONFIGURATION
- Create a new "AI search" backend in Search API

## MAINTAINERS

Current maintainers for Drupal 10:

- Albert Skibinski (askibinski) - https://www.drupal.org/u/askibinski

