<?php

namespace Drupal\ai_vdb_provider_mysql;

use mysqli;

class MysqliConnectionFactory {
  public static function getConnection(): mysqli {
    $database = \Drupal::database();
    $connection_options = $database->getConnectionOptions();

    $mysqli = new mysqli(
      $connection_options['host'],
      $connection_options['username'],
      $connection_options['password'],
      $connection_options['database'],
      $connection_options['port']
    );

    if ($mysqli->connect_error) {
      throw new \Exception('Could not connect to the database.');
    }

    return $mysqli;
  }
}
