<?php

namespace Drupal\ai_vdb_provider_mysql;

use MHz\MysqlVector\VectorTable;
use mysqli;
use Drupal\Core\Config\ConfigFactoryInterface;

class VectorTableFactory {
  private mysqli $mysqli;
  private ConfigFactoryInterface $configFactory;

  public function __construct(mysqli $mysqli, ConfigFactoryInterface $configFactory) {
    $this->mysqli = $mysqli;
    $this->configFactory = $configFactory;
  }

  /**
   * Returns an instance of the VectorTable class.
   *
   * @param string $collection_name
   *   The collection name
   *
   * @param int $dimension
   *   The vector dimension.
   *
   * @return \MHz\MysqlVector\VectorTable
   *   The Vector Table instance.
   */
  public function getVectorTable(string $collection_name, int $dimension): VectorTable {
    // 2040 is currently the max we can support, it translates to a length of
    // 255 bytes (2040/8) which is done by mysql-vector.
    return new VectorTable($this->mysqli, $collection_name, $dimension);
  }
}
