# AI Webform Guard

AI Webform Guard is a lightweight Drupal module that protects your [Webform](https://www.drupal.org/project/webform) submissions from spam using AI-powered classification.

Instead of using traditional CAPTCHA mechanisms, this module analyzes submissions in real time by sending a prompt to an LLM (e.g. OpenAI) and classifies the content as spam or not.

> This module integrates with the [AI module](https://www.drupal.org/project/ai) for Drupal.

---

## Features

-  Integrates with [Webform](https://www.drupal.org/project/webform)
-  Uses LLM-based AI detection to classify form submissions
-  Configurable AI model and prompt template (via admin UI)
-  Prompt supports multilingual rendering and Twig tokens
-  Logs blocked spam attempts (optional)

---

## Requirements

- [Webform](https://www.drupal.org/project/webform)
- [AI module](https://www.drupal.org/project/ai)
- A working AI provider (e.g. OpenAI, OpenRouter, etc.)

---

## Installation

1. Install via composer:
   ```bash
   composer require drupal/ai_webform_guard
