<?php

namespace Drupal\ai_webform_guard\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\webform\Entity\Webform;

/**
 * Defines a settings form for AI Webform Guard.
 */
class AIWebformGuardFieldsSettingsForm extends ConfigFormBase {

  /**
   * Config settings.
   */
  const CONFIG_NAME = 'ai_webform_guard_fields.settings';

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'ai_webform_guard_fields_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      static::CONFIG_NAME,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config(static::CONFIG_NAME);
    $excluded_fields_config = $config->get('excluded_fields') ?? [];

    $form['description'] = [
      '#markup' => $this->t('<p>Select which webform fields should be excluded from AI spam detection.</p>'),
    ];

    $form['excluded_fields'] = [
      '#type' => 'fieldset',
      '#tree' => TRUE,
    ];

    $webforms = Webform::loadMultiple();

    foreach ($webforms as $webform_id => $webform) {
      $form['excluded_fields'][$webform_id] = [
        '#type' => 'details',
        '#title' => $webform->label(),
        '#open' => FALSE,
      ];

      $elements = $webform->getElementsInitializedFlattenedAndHasValue();

      foreach ($elements as $key => $element) {
        $form['excluded_fields'][$webform_id][$key] = [
          '#type' => 'checkbox',
          '#title' => $element['#title'] ?? $key,
          '#default_value' => $excluded_fields_config[$webform_id][$key] ?? FALSE,
        ];
      }
    }

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $excluded_fields = $form_state->getValue('excluded_fields') ?? [];

    $this->config(static::CONFIG_NAME)
      ->set('excluded_fields', $excluded_fields)
      ->save();

    parent::submitForm($form, $form_state);
  }

}
