# AI Webform Guard

AI Webform Guard is a lightweight Drupal module that protects your [Webform](https://www.drupal.org/project/webform) submissions from spam using AI-powered classification.

Instead of using traditional CAPTCHA mechanisms, this module analyzes submissions in real time by sending a prompt to an LLM (e.g. OpenAI) and classifies the content as spam or not.

> This module integrates with the [AI module](https://www.drupal.org/project/ai) for Drupal.

---

## Features

-  Integrates with [Webform](https://www.drupal.org/project/webform)
-  Uses LLM-based AI detection to classify form submissions
-  Configurable AI model and prompt template (via admin UI)
-  Option to configure specific fields to be excluded from spam detection.
-  Custom error messages for spam submissions.
-  Logs blocked spam attempts (optional)
-  Human iteration support: Adds a checkbox for manual confirmation if submission is flagged as spam
-  Submission truncation: Limits the number of words sent to AI via max_words setting to reduce token usage

---

## Requirements

- [Webform](https://www.drupal.org/project/webform)
- [AI module](https://www.drupal.org/project/ai)
- A working AI provider (e.g. OpenAI, OpenRouter, etc.)

---

## Installation

1. Install via composer:
    ```bash
    composer require drupal/ai_webform_guard
    ```
2. Enable the module:
   ```bash
   drush en ai_webform_guard -y
   ```
3. Configure the AI provider and settings under **Administration > Configuration > AI Webform Guard settings**.

## Configuration
### AI Provider Settings
- **Webform guard generation prompt:** This is the prompt that you'll send to the AI model for analyzing submissions. It should guide the AI to give meaningful classifications.
- **AI provider/model:** Choose the appropriate AI provider and model that you want to utilize for spam detection.
- **Custom error message for spam submissions:** You can specify a custom error message that will be displayed if a submission is identified as spam. If left empty, the default message will be used.
- **Log spam attempts:** Optionally enable logging of blocked spam submissions to help audit and monitor potential spam activity.
- **Human Iteration** Confirmation checkbox. If enabled, flagged submissions require manual confirmation before being allowed. The checkbox appears only for submissions flagged as potential spam.
- **Submission Truncation** Maximum words per AI request. Limits how many words from the Webform submission are sent to the AI to reduce token usage.
  On average, one word equals ~1.3–1.5 tokens. Useful for long forms.

### Field Exclusion Settings
- You can set the AI to ignore specific fields in the webform submission by configuring the excluded fields. This can be managed under **Administration > Configuration > AI Webform Guard Fields settings**.

## Usage
1. Create your webform as usual.
2. Configure the settings according to your AI provider and preferences.
3. Test submissions to see the spam detection in action.
4. Flagged submissions will show a confirmation checkbox if human iteration is enabled, and AI will classify content based on field labels even for nested/grouped fields.
5. Long submissions will be truncated according to max_words to limit AI token usage.
