<?php
namespace Drupal\aidmi\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configuration form for your module.
 */
class AidmiSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['aidmi.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'aidmi_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('aidmi.settings');

    // Radio buttons for API selection
    $form['selected_api'] = [
      '#type' => 'radios',
      '#title' => $this->t('Select API'),
      '#options' => [
        'gemini' => $this->t('Google Gemini'),
      ],
      '#default_value' => $config->get('selected_api'),
      '#description' => $this->t('Select which API to use for processing.'),
      '#required' => TRUE,
    ];

    // Field for the API key
    $form['api_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('API Key'),
      '#default_value' => $config->get('api_key'),
      '#description' => $this->t('Enter the API key for making requests.'),
      '#required' => TRUE,
    ];

    // Field for the API instructions
    $form['api_instructions'] = [
      '#type' => 'textarea',
      '#title' => $this->t('API Instructions'),
      '#default_value' => $config->get('api_instructions'),
      '#description' => $this->t('Provide the string of instructions to be passed to the API.'),
      '#required' => TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->configFactory->getEditable('aidmi.settings')
      ->set('selected_api', $form_state->getValue('selected_api'))  // Save selected API
      ->set('api_key', $form_state->getValue('api_key'))
      ->set('api_instructions', $form_state->getValue('api_instructions'))
      ->save();

    parent::submitForm($form, $form_state);
  }
}
