let activeEditorInstance = null;
(function ($, Drupal, once) {
  Drupal.behaviors.ckeditorImageUploadMonitor = {
    attach: function (context, settings) {

      // Set the last active CKEditor
      once('getActiveCKEditorInstance', '.ck-editor__editable', context).forEach(function (editorElement) {
        // Attach a focus event listener to detect when an editor becomes active
        editorElement.addEventListener('focus', function () {
          activeEditorInstance = editorElement.ckeditorInstance;
        });
      });


      // Select the target node (element) you want to observe
      const targetNode = document.body; // You can change this to any specific element

      // Define the configuration for the observer (which types of changes to monitor)
      const config = {
        childList: true,       // Monitor additions or removals of child elements
        attributes: true,      // Monitor changes to attributes
        characterData: false,  // Don't monitor changes to text content
        subtree: true,         // Extend monitoring to all descendants of the observed node
        attributeFilter: ['class', 'src'],  // Only monitor changes to 'class' and 'src' attributes
        attributeOldValue: true // Record the previous value of changed attributes
      };

      // Define the callback function that will be triggered when mutations are observed
      const callback = (mutationsList) => {
        mutationsList.forEach((mutation) => {    
          if (mutation.type === 'attributes') {
            //  && $('.ck-text-alternative-form')
            const regex = /^ck-labeled-field-view/;
            if (typeof mutation.target !== 'undefined' && regex.test(mutation.target.id)) {
              altTextField = mutation.target;
              imgTag = activeEditorInstance.data.stringify(activeEditorInstance.model.getSelectedContent(activeEditorInstance.model.document.selection));
              if (altTextField) {
                aidmiButton(altTextField, activeEditorInstance, imgTag);
              }
            }
          }
        });
      };

      // Create an instance of MutationObserver and pass the callback function
      const observer = new MutationObserver(callback);    
      // Start observing the target node with the provided configuration
      observer.observe(targetNode, config);

      // Function to add the AIDmi Button
      function aidmiButton(altTextField, ckEditorInstance, imgTag) {
        // Check if the image has a data-entity-uuid
        uuidMatch = imgTag.match(/^<img[^>]*data-entity-uuid="([^"]*)"/);
        if (uuidMatch) {
          imgUuid = uuidMatch[1];
        }

        const existingButton = document.querySelector('.aidmi-button');  // Check if the button already exists
      
        if (!existingButton) {
          const button = document.createElement('button');
          button.type = 'button';  // Set the button type to 'button' to avoid form submission behavior
          button.textContent = 'AI, describe my image!';
          button.classList.add('aidmi-button');
          // Attach the click event to disable the button after click
          button.onclick = (e) => {
            e.preventDefault();
            // Disable the button immediately after click
            button.disabled = true;
            button.textContent = 'AIDmi Processing...';
            // Call the aidmiAjax function and handle the result with .then()
            imgDesc = aidmiAjax(imgUuid)
                        .then((data) => {
                          if (confirm("Do you want to use this description?\n\n" + data)) {
                            // Once the promise resolves, set the actual text into the field
                            altTextField.value = data;  // Set the resolved data to the field
                            altTextField.focus();
                            // Manually trigger the onchange event
                            const event = new Event('change', {
                              bubbles: true,  // Ensure the event bubbles up the DOM
                              cancelable: true  // Allow the event to be cancelable
                            });
                            altTextField.dispatchEvent(event);  // Dispatch the event on the input field
                          }
                        })
                        .catch((error) => {
                          console.error('Error:', error);  // Handle errors here
                          altTextField.focus();
                          alert(t('AI connection error, please contact support.'))
                        })
                        .finally(() => {
                          // Re-enable the button once the AJAX call is complete
                          button.disabled = false;  // Re-enable the button
                          button.textContent = 'AI, describe my image!';
                        });
            };
            // Add the button to the DOM
            altTextField.parentElement.appendChild(button);
        }
      }

      function aidmiAjax(uuid) {
        // Initially clear the field or show a placeholder/loading message
        altTextField.value = '';  // Keep the field empty
        // Return a Promise that resolves when the AJAX call succeeds
        return new Promise((resolve, reject) => {
          $.ajax({
            url: '/admin/aidmi/describe-image-ajax/' + uuid,
            type: 'GET',
            success: function (data) {
              // Resolve the promise with the data from the AJAX call
              resolve(data);
            },
            error: function (xhr, status, error) {
              // Reject the promise if there's an error
              reject(error);
            }
          });
        });
      }
    }
  };
})(jQuery, Drupal, once);
