(function ($, Drupal) {
    Drupal.behaviors.aidmiDialog = {
        attach: function (context, settings) {    
        Drupal.aidmi = Drupal.aidmi || {};            
        
        Drupal.aidmi.aidmiDialog = function (content, callback) {
            let aidmiEditedText;
            // Create a temporary container to hold the content.
            const tempElement = document.createElement('div');
            tempElement.setAttribute('role', 'dialog');
            tempElement.setAttribute('aria-labelledby', 'aidmi-dialog-title');
            tempElement.setAttribute('aria-describedby', 'aidmi-dialog-description');
            tempElement.setAttribute('aria-modal', 'true'); // Ensures screen readers treat the dialog as a modal.

            // Set title text.
            let tempETitle = 'AIDmi Description';
            let tempESubTitle = 'Please evaluate and edit the description as needed.';

            // Create dialog content with a textarea for editing.
            tempElement.innerHTML = `
            <div>
                <h2 id="aidmi-dialog-title">${Drupal.t(tempETitle)}</h2>
                <p id="aidmi-dialog-subtitle" class="aidmi-dialog-subtitle">${Drupal.t(tempESubTitle)}</p>
                <textarea id="aidmi-dialog-textarea" class="aidmi-dialog-textarea" rows="6" style="width: 100%;">${Drupal.t(content)}</textarea>
            </div>`;

            // Store the element that triggered the dialog, to return focus later.
            const previousFocus = document.activeElement;

            // Use the Drupal off-canvas dialog to show the content.
            const options = {
            dialogClass: 'aidmi-dialog',
            title: tempETitle,
            width: '400px',
            buttons: [
                {
                text: Drupal.t('Insert Text'),
                click: function () {
                    // Get the value from the textarea.
                    aidmiEditedText = document.getElementById('aidmi-dialog-textarea').value;

                    // Pass the modified text back through the callback.
                    callback(aidmiEditedText);

                    // Close the dialog.
                    $(tempElement).dialog('close');
                    $(tempElement).dialog('destroy').remove(); // Properly remove the dialog from the DOM.
                }
                },
                {
                text: Drupal.t('Cancel'),
                click: function () {
                    // Return false when Cancel is clicked.
                    callback(false);

                    // Close the dialog.
                    $(tempElement).dialog('close');
                    $(tempElement).dialog('destroy').remove(); // Properly remove the dialog from the DOM.
                }
                }
            ],
            close: function () {
                // Return focus to the original element when the dialog is closed.
                previousFocus.focus();
            }
            };

            // Open the dialog using Drupal's dialog API.
            const dialogInstance = Drupal.dialog(tempElement, options);
            dialogInstance.showModal();

            // Set focus on the textarea for screen readers.
            const textareaElement = document.getElementById('aidmi-dialog-textarea');
            textareaElement.setAttribute('tabindex', '-1');
            textareaElement.focus();

            // Ensure the Esc key closes the dialog.
            document.addEventListener('keydown', function (event) {
            if (event.key === 'Escape') {
                // Close the dialog.
                $(tempElement).dialog('close');
                $(tempElement).dialog('destroy').remove(); // Properly remove the dialog from the DOM.
            }
            });
        }
    }
  };
})(jQuery, Drupal);