<?php

namespace Drupal\aidmi\Controller;

use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\aidmi\Service\GeminiAiService;
use Drupal\Core\Render\Element;
use Symfony\Component\HttpFoundation\JsonResponse;
use Drupal\file\Entity\File;

class AidmiController {
  protected $geminiAiService;

  public function __construct(GeminiAiService $geminiAiService) {
    $this->geminiAiService = $geminiAiService;
  }

  public static function create(ContainerInterface $container): self {
    return new static(
      $container->get('aidmi.ai_service')
    );
  }

  public function analyzeImage(int $fid): Response {
    // Set the file ID in drupalSettings so it can be accessed in JavaScript.
    $build = [];
    $build['#attached']['drupalSettings']['aidmi'] = [
      'imageFid' => $fid,
    ];
  
    $description = $this->geminiAiService->analyzeImage($fid);
  
    // Return a response for the page.
    return new Response($description);
  }

  public function analyzeImageAjax(string $uuid): Response {
    $fid = $this->getFileIdByUuid($uuid);
    if ($fid) {
      $description = $this->geminiAiService->analyzeImage($fid);
      return new Response($description);
    }
    return null;
  }

  public function analyzeContentAjax(): Response {
    // Get the raw POST data from the request.
    $content = \Drupal::request()->request->get('content');
    $imagesJSON = \Drupal::request()->request->get('imagesJSON');
    $description = null;
    
    if (!empty($content)) {
      $description = $this->geminiAiService->analyzeContent($content, $imagesJSON);
    }    

    return new Response($description);
  }
  
  public function getFileIdByUuid(string $uuid) {
    // Query for the file entity using the UUID.
    $file = \Drupal::entityTypeManager()->getStorage('file')->loadByProperties(['uuid' => $uuid]);

    if ($file) {
      $file = reset($file);  // Get the first result.
      return $file->id();
    } else {
      return null;
    }
  }
}
