<?php

declare(strict_types = 1);

namespace Drupal\aidmi\Plugin\CKEditor5Plugin;

use Drupal\ckeditor5\Plugin\CKEditor5PluginDefault;
use Drupal\Core\Url;
use Drupal\editor\EditorInterface;

/**
 * Plugin class to add dialog url for embedded content.
 */
class aidmi extends CKEditor5PluginDefault {

  /**
   * {@inheritdoc}
   */
  public function getDynamicPluginConfig(array $static_plugin_config, EditorInterface $editor): array {
    $aidmi_dialog_url = Url::fromRoute('ckeditor5_aidmi.dialog')
      ->toString(TRUE)
      ->getGeneratedUrl();
    $static_plugin_config['aidmi']['dialogURL'] = $aidmi_dialog_url;
    $aidmi_preview_url = Url::fromRoute('ckeditor5_aidmi.preview', [
      'editor' => $editor->id(),
    ])
      ->toString(TRUE)
      ->getGeneratedUrl();
    // $static_plugin_config['aidmi']['previewURL'] = $aidmi_preview_url;
    return $static_plugin_config;
  }

}
