(function ($, Drupal, once) {
                
  Drupal.aidmi = Drupal.aidmi || {};
  
  Drupal.behaviors.ckeditorImageUploadMonitor = {
    attach: function (context, settings) {

      // Define the configuration for the observer (which types of changes to monitor).
      const config = {
        childList: true,       // Monitor additions or removals of child elements.
        attributes: true,      // Monitor changes to attributes.
        characterData: false,  // Don't monitor changes to text content.
        subtree: true,         // Extend monitoring to all descendants of the observed node.
        attributeFilter: ['class', 'src'],  // Only monitor changes to 'class' and 'src' attributes.
        attributeOldValue: true // Record the previous value of changed attributes.
      };

      // Define the callback function that will be triggered when mutations are observed.
      const callback = (mutationsList) => {
        mutationsList.forEach((mutation) => {    
          if (mutation.type === 'attributes') {
            // Find id starting with...
            let regex = /^ck-labeled-field-view/;
            if (typeof mutation.target !== 'undefined' && regex.test(mutation.target.id)) {
              let editorElement = document.querySelector('.ck-editor__editable');            
              Drupal.aidmi.activeEditorInstance = editorElement.ckeditorInstance;
              
              const existingButton = document.querySelector('.aidmi-button');  // Check if the button already exists.
              // Find in old class value.
              regex = /ck-input_focused/;
              if (regex.test(mutation.oldValue) && (existingButton)) {
                //existingButton.focus();
              }
              altTextField = mutation.target;
              // Check if the alternative text form exists.
              altTextForm = document.querySelector('.ck-text-alternative-form');
              // Get the selected image.
              imgTag = Drupal.aidmi.activeEditorInstance.data.stringify(Drupal.aidmi.activeEditorInstance.model.getSelectedContent(Drupal.aidmi.activeEditorInstance.model.document.selection));
              if ((altTextForm) && (altTextField) && (imgTag)) {
                Drupal.aidmi.aidmiButton(altTextField, Drupal.aidmi.activeEditorInstance, imgTag);
              }
            }
          }
        });
      };

      // Create an instance of MutationObserver and pass the callback function.
      const observer = new MutationObserver(callback);
      // Select the target node (element) you want to observe.
      const targetNode = document.body; // You can change this to any specific element.
      // Start observing the target node with the provided configuration.
      observer.observe(targetNode, config);
    }
  }
  
  Drupal.behaviors.aidmiCKEditorFunctions = {
    attach: function (context, settings) {     
      Drupal.aidmi.lastSelection = '';

      // Function to add the AIDmi Button.
      Drupal.aidmi.aidmiButton = function (altTextField, ckEditorInstance, imgTag) {
        // Check if the image has a data-entity-uuid.
        uuidMatch = imgTag.match(/<img[^>]*data-entity-uuid="([^"]*)"/);
        if (uuidMatch) {
          imgUuid = uuidMatch[1];
        }
        const existingButton = document.querySelector('.aidmi-button');  // Check if the button already exists.
        let aidmiEditedText = '';

        if (!existingButton) {
          const button = document.createElement('button');
          button.type = 'button';  // Set the button type to 'button' to avoid form submission behavior.
          button.textContent = 'AI, describe my image!';

          // CSS
          button.classList.add('aidmi-button');
          button.classList.add('ck');
          button.classList.add('ck-button');
          button.classList.add('button--action');
          button.classList.add('button--secondary');
          button.classList.add('link-icon');   

          // Make sure the button is focusable via keyboard (part of tabbing order).
          button.setAttribute('tabindex', '1');          
          // Add ARIA attributes for accessibility
          button.setAttribute('role', 'button');
          button.setAttribute('aria-label', 'AI, describe my image button');
          button.setAttribute('aria-describedby', 'This button will use AI to generate a description for the image');          
          
          // Attach the click event to disable the button after click.
          button.onclick = (e) => {
            e.preventDefault();
            // Disable the button immediately after click.
            button.disabled = true;
            button.textContent = 'AIDmi Processing...';
            // Call the aidmiAjax function and handle the result with .then().
            imgDesc = Drupal.aidmi.aidmiAjax(imgUuid)
                        .then((data) => {
                          // Capture the current selection before opening the dialog.
                          captureSelection(Drupal.aidmi.activeEditorInstance);
                          // Open the Off-Canvas Dialog and show the retrieved description.
                          Drupal.aidmi.aidmiDialog(data, (aidmiEditedText) => {
                            if (aidmiEditedText) {
                              // Check if the imgTag has an alt attribute.
                              updateImageAltInCKEditor(ckEditorInstance, imgUuid, aidmiEditedText);
                            }
                          });                     
                          // Restore the CKEditor selection after closing the dialog.
                          restoreSelection(Drupal.aidmi.activeEditorInstance);
                        })
                        .catch((error) => {
                          console.log('Error:', error);  // Handle errors here.
                          alert(Drupal.t('AI connection error, please contact support.'));
                        })
                        .finally(() => {
                          // Re-enable the button once the AJAX call is complete.
                          button.disabled = false;  // Re-enable the button.
                          button.textContent = 'AI, describe my image!';
                        });
            };
            // Add the button to the DOM.
            altTextField.parentElement.appendChild(button);
            // Set focus on the button explicitly to ensure it's reachable by keyboard.
            button.focus();
        } else {
        }
      }

      Drupal.aidmi.aidmiAjax = function (uuid) {
        // Return a Promise that resolves when the AJAX call succeeds.
        return new Promise((resolve, reject) => {
          $.ajax({
            url: '/admin/aidmi/describe-image-ajax/' + uuid,
            type: 'GET',
            success: function (data) {
              // Resolve the promise with the data from the AJAX call.
              resolve(data);
            },
            error: function (xhr, status, error) {
              // Reject the promise if there's an error.
              reject(error);
            }
          });
        });
      }

      // Capture the selection before opening the dialog.
      function captureSelection(editorInstance) {
        const selection = editorInstance.model.document.selection;
      
        // If there's a selection, clone it to restore later.
        if (selection) {
          Drupal.aidmi.lastSelection = selection.getFirstRange().clone();
        }
      }

      // Restore that last selection.
      function restoreSelection(editorInstance) {
        if (Drupal.aidmi.lastSelection) {
          editorInstance.model.change(writer => {
            // Restore the selection.
            writer.setSelection(Drupal.aidmi.lastSelection);
          });
      
          // Focus the editor view.
          editorInstance.editing.view.focus();
        }
      }

      // Update image alt tag in CKEditor
      function updateImageAltInCKEditor(editorInstance, imgUuid, newAltText) {
        // Get the model from the CKEditor instance.
        const model = editorInstance.model;
      
        // Use the model.change() to make sure CKEditor is aware of the modification.
        model.change(writer => {
          // Get the root of the document.
          const root = model.document.getRoot();
      
          // Traverse the root to find the image element by uuid.
          for (const item of model.createRangeIn(root)) {
            const element = item.item;
      
            // Check if the element is an image and matches the imgUuid
            if (element.is('element', 'imageBlock') || element.is('element', 'imageInline')) {
              // Get the element in CKEditor by the UUID.
              const uuid = element.getAttribute('dataEntityUuid');
              if (uuid === imgUuid) {
                // Update the alt attribute using CKEditor's writer
                writer.setAttribute('alt', newAltText, element);
                // Set the selection on the image element.
                const range = model.createRangeOn(element);
                writer.setSelection(range);
              }
            }
          }
        });
      }
    }
  };
})(jQuery, Drupal, once);
