(function ($, Drupal) {

  'use strict';

  const intersectionObserver = new IntersectionObserver((entries) => {
    entries.forEach((entry) => {
      if (entry.isIntersecting) {
        const placeholderElement = entry.target
        intersectionObserver.unobserve(placeholderElement);
        ajaxBigPipeLoad(placeholderElement);
      }
    })
  })

  function ajaxBigPipeProcessDocument(context) {
    $('[data-ajax-placeholder]', context).once('ajax-bigpipe').each(function (placeholderElement) {
      intersectionObserver.observe(this);
    });
  }

  function ajaxBigPipeLoad(placeholderElement) {
    const ajax = new Drupal.ajax({
      url: drupalSettings.ajaxBigPipe,
      progress: false,
      submit: JSON.parse(placeholderElement.dataset.ajaxPlaceholder)
    })
    ajax.success = function (response, status) {
      // Call all provided AJAX commands.
      Object.keys(response || {}).forEach(function (i) {
        if (response[i].command && ajax.commands[response[i].command]) {
          if (!response[i].selector) {
            if (!response[i].selector) {
              // Set selector by our element.
              response[i].selector = placeholderElement;
            }
          }
          ajax.commands[response[i].command](ajax, response[i], status);
        }
      });
      Drupal.attachBehaviors();

      $('body').trigger('ajaxBigPipeLoad', []);
    };
    ajax.options.type = 'GET';
    ajax.submit.destination = window.location.pathname;
    ajax.execute();
  }

  $(window).on('load', function () {
    ajaxBigPipeProcessDocument(document);
  });

})(jQuery, Drupal);