<?php

namespace Drupal\ajax_big_pipe;

use Drupal\Core\Security\TrustedCallbackInterface;

/**
 * Class of LazyBlockBuilder.
 */
class LazyBlockBuilder implements TrustedCallbackInterface {

  /**
   * Builds a render array for a block lazily.
   *
   * @param string $blockId
   *   The unique identifier of the block.
   */
  public function lazyBlockBuild(string $blockId): array {
    return [
      '#markup' => $blockId,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public static function trustedCallbacks(): array {
    return ['lazyBlockBuild'];
  }

}
