# Ajax Callbacks Field Formatter
This module allow you to inject some Ajax Commands in a easily and generic way.

To do it, it provides a new field formatter which only apply on the field type Link.
This formatter use the URL part as the url to the Ajax Callback.
And the text part as default value (the displayed value in case the JS fail).

It provides  a simply JS which performs the ajax callback request and execute the returned ajax command.

## How to use it

### Apply the formatter
Add a new field Link to your entity.
After that you just need to apply the "Ajax Callback Formatter" formatter (manage display).

This formatter will slightly alter your field Link by :
- Transform the render element form link (\<a\>') to span (\<span\>).
- Add 2 new attributes to the render element :
  - data-execute-ajax-callback-field-formatter-url : Filled with the url from the link field
  - data-execute-ajax-callback-field-formatter-id : Build with the following pattern "[entity_type]--[entity_id]--[field_name]--[delta]" with :
    - entity_type : The type of the entity containing the field
    - entity_id : The ID of the entity containing the field
    - field_name : The field name.
    - delta : The element's delta.`

### Implemtents your custom Controller
Create a new controller as usually. Defines its route.
Methods used by the "Ajax Replace Formatter" should returns an AjaxResponse with an AjaxCommand.
Create or edit your entity to add the new route in the URL part of your link field which using the "Ajax Callback Formatter" formatter.

That's all !
